#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <stdbool.h>

#define MAX_VOZILA 1000

typedef enum smer
{
    SMER_1,
    SMER_2
} smer;

struct
{
    smer aktivni_smer;
    unsigned int broj_vozila[3];
} nadvoznjak;

typedef enum tip_vozila
{
    AUTOMOBIL = 0,
    AUTOBUS,
    KAMION
} tip_vozila;

struct vozilo
{
    smer smer;
    tip_vozila tip;
    unsigned int id;
};

pthread_mutex_t lock;
pthread_cond_t cond;

const char* vozilo_str[] = { "Automobil", "Autobus", "Kamion" };
const unsigned int vreme_prelaska[3] = {3, 5, 8};

bool ima_vozila()
{
    return ((nadvoznjak.broj_vozila[AUTOMOBIL] != 0) ||
        (nadvoznjak.broj_vozila[AUTOBUS] != 0) ||
        (nadvoznjak.broj_vozila[KAMION] != 0));
}

bool moze_preci(struct vozilo v)
{
    bool moze_preci;
    if(v.tip == AUTOMOBIL)
    {
        moze_preci = (nadvoznjak.broj_vozila[KAMION] == 0) &&
        (!ima_vozila() || ((nadvoznjak.aktivni_smer == v.smer)));
    }
    else if(v.tip == AUTOBUS)
    {
        moze_preci = (nadvoznjak.broj_vozila[KAMION] == 0) &&
        (!ima_vozila() || ((nadvoznjak.aktivni_smer == v.smer) && (nadvoznjak.broj_vozila[AUTOBUS] == 0)));
    }
    else // vozilo.tip = KAMION
    {
        moze_preci = !ima_vozila();
    }
    return moze_preci;
}

void stani_na_nadvoznjak(struct vozilo v)
{
    if(!ima_vozila())
        nadvoznjak.aktivni_smer = v.smer;

    nadvoznjak.broj_vozila[v.tip]++;
}

void sidji_sa_nadvoznjaka(struct vozilo v)
{
    nadvoznjak.broj_vozila[v.tip]--;
}

void* vozilo_fn(void* data)
{
    struct vozilo v = *(struct vozilo*)data;

    printf("%s %d | Ceka\n", vozilo_str[v.tip], v.id);

    pthread_mutex_lock(&lock);

    while(!moze_preci(v))
    {
        pthread_cond_wait(&cond, &lock);
    }

    stani_na_nadvoznjak(v);

    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&lock);

    printf("%s %d | Prelazi...\n", vozilo_str[v.tip], v.id);
    sleep(vreme_prelaska[v.tip]); // prelazi nadvoznjak

    pthread_mutex_lock(&lock);

    printf("%s %d | Silazi\n", vozilo_str[v.tip], v.id);
    sidji_sa_nadvoznjaka(v);

    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&lock);

    return NULL;
}

struct vozilo napravi_vozilo(smer smer, tip_vozila tip, unsigned int brojac[3])
{
    return (struct vozilo) {
        .smer = smer,
        .tip = tip,
        .id = (++brojac[tip])
    };
}

#define UKUPNO(brojac) (brojac[AUTOMOBIL] + brojac[AUTOBUS] + brojac[KAMION])

int main()
{
    pthread_mutex_init(&lock, NULL);
    pthread_cond_init(&cond, NULL);

    // nadvoznjak
    nadvoznjak.aktivni_smer = SMER_1;
    nadvoznjak.broj_vozila[AUTOMOBIL] = 0;
    nadvoznjak.broj_vozila[AUTOBUS] = 0;;
    nadvoznjak.broj_vozila[KAMION] = 0;

    // vozila
    struct vozilo vozila[MAX_VOZILA] = {0};
    pthread_t vozila_threads[MAX_VOZILA] = {0};
    unsigned int brojac[3] = {0};

    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_2, KAMION, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOMOBIL, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOMOBIL, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOMOBIL, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOBUS, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOBUS, brojac);
    vozila[UKUPNO(brojac)] = napravi_vozilo(SMER_1, AUTOMOBIL, brojac);

    size_t i;

    // kreacija threadova
    for(i = 0; i < UKUPNO(brojac); i++)
    {
        pthread_create(&(vozila_threads[i]), NULL, vozilo_fn, &(vozila[i]));
        usleep(100000); // prilaze nekim redom
    }

    // spajanje threadova
    for(i = 0; i < UKUPNO(brojac); i++)
        pthread_join(vozila_threads[i], NULL);

    pthread_mutex_destroy(&lock);
    pthread_cond_destroy(&cond);

    return 0;
}
